*Net Exit Rates


*---------------------------------------------------------------
* Construct ks.dta

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\ce.dta", clear

rename _1987 ce1987
rename _1988 ce1988
rename _1989 ce1989
rename _1990 ce1990
rename _1991 ce1991
rename _1992 ce1992
rename _1993 ce1993
rename _1994 ce1994
rename _1995 ce1995
rename _1996 ce1996
rename _1997 ce1997
rename _1998 ce1998
rename _1999 ce1999
rename _2000 ce2000
rename _2001 ce2001

sort sic
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\gdp.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta"

rename _1987 gdp1987
rename _1988 gdp1988
rename _1989 gdp1989
rename _1990 gdp1990
rename _1991 gdp1991
rename _1992 gdp1992
rename _1993 gdp1993
rename _1994 gdp1994
rename _1995 gdp1995
rename _1996 gdp1996
rename _1997 gdp1997
rename _1998 gdp1998
rename _1999 gdp1999
rename _2000 gdp2000
rename _2001 gdp2001
drop _merge
sort sic
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\adjustment.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta"
drop _merge
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", replace

*------------------------------------------------------------------------------------------
* Filling the 

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\est1994.dta", clear
rename establishments est1994
fillin sic establishment_size
replace est1994 = 0 if est1994==.
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1994.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\est1995.dta", clear
rename establishments est1995
fillin sic establishment_size
replace est1995 = 0 if est1995==.
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1995.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\est1997.dta", clear
rename establishments est1997
fillin sic establishment_size
replace est1997 = 0 if est1997==.
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1997.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\entries9596.dta", clear
fillin sic establishment_size
replace _1996 = 0 if _1996==.
replace _1997 = 0 if _1997==.
replace _1999 = 0 if _1999==.
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intentries9596.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\exits9596.dta", clear
fillin sic establishment_size
replace _1995 = 0 if _1995==.
replace _1994 = 0 if _1994==.
replace _1992 = 0 if _1992==.
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intexits9596.dta", replace

*----------------------------------------------------------------------------------------
*Construct estall.dta

*Merge all data
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intexits9596.dta", clear
sort sic establishment_size
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intentries9596.dta", clear
merge sic establishment_size using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
rename _1999 l1999
rename _1992 l1992
rename _1996 l1996
rename _1994 l1994
rename _1995 l1995
rename _1997 l1997
sort sic establishment_size
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1994.dta", clear
sort sic establishment_size
merge sic establishment_size using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
sort sic establishment_size
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1995.dta", clear
sort sic establishment_size
merge sic establishment_size using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
sort sic establishment_size
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1997.dta", clear
sort sic establishment_size
merge sic establishment_size using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
sort sic establishment_size
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

* Aggregating industry bins and defining size bins

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", clear
rename establishment_size minsize
* Selecting SIC
drop if  sic=="0700"
drop if  sic=="0800"
drop if  sic=="0900"
drop if sic=="10--"
drop if  sic=="1500"
drop if  sic=="1600"
drop if  sic=="1700"
replace sic = "-1" if sic=="20--"
drop if  sic=="40--"
drop if  sic=="60--"
drop if  sic=="5000"
drop if  sic=="5100"
drop if  sic=="5200"
drop if  sic=="5300"
drop if  sic=="5400"
drop if  sic=="5500"
drop if  sic=="5600"
drop if  sic=="5700"
drop if  sic=="5800"
drop if  sic=="5900"
drop if  sic=="70--"
drop if sic=="99--"
replace sic = "709" if sic=="07--"
replace sic = "1517" if sic=="15--"
replace sic = "5051" if sic=="50--"
replace sic = "5259" if sic=="52--"
replace sic = "8489" if (sic=="8400")|(sic=="8700")|(sic=="8900")
collapse (sum) est1994 est1995 est1997 l1996 l1992 l1999 l1994 l1995 l1997, by(sic minsize)

*Define size
drop if minsize=="0 employees"
drop if minsize=="Total"
replace minsize = "10000" if minsize =="10,000 or more employees" 
gen size = word(subinstr(minsize,"-"," -",. ),1)
replace size = subinstr(size,",","",. )
replace size="10000" if minsize=="10000"
destring size, replace
drop minsize
gen minsize = size
drop size
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intestall.dta", replace
gen avsize = 0
collapse avsize , by(minsize)
replace avsize = (minsize+minsize[_n+1] - 1)/2
replace avsize = 12500 if minsize==10000
sort minsize

save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

* Merge with ks.dta
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intestall.dta", clear
sort minsize
merge minsize using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
replace sic = "0" if sic=="----"
destring sic, replace
sort sic avsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intestall.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\intestall.dta"
drop _merge
sort sic avsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

*---------------------------------
*Definition of the variables

* Definition of number of establishments living in 1996 (note: we neglect firms whose bin change, e.g. if the size changes enough between 1995 and 1996)
gen est1996 = est1995 - l1995 + l1996

* Definition of KS
gen ksav= 1-(ce1990/gdp1990+ce1991/gdp1991+ce1992/gdp1992+ce1993/gdp1993+ce1994/gdp1994+ce1995/gdp1995+ce1996/gdp1996+ce1997/gdp1997+ce1998/gdp1998+ce1999/gdp1999+ce2000/gdp2000)/11
gen ksavadj = ksav*adjustment

* Regressors
gen logsize = ln(avsize)
gen ksavlsize = ksav*logsize
gen ksavadjlsize = ksavadj*logsize

* Dependent Variables
gen logTurnRate9596 = ln(1+2*(l1995-l1996)/(est1995+est1996))
gen logTurnRate9497 = ln(1+2*(l1994-l1997)/(est1994+est1997))

* weigths
gen unest = est1996+l1995
gen we1 = unest
gen we2 = we1

*----------------------------------------------------------------------------------
*Regression 1995-1996

replace we1 = (est1995+est1996)^2/unest
*xi: reg  logTurnRate9596 i.sic logsize  ksavlsize [aw=we1] if (ksav <= 0.5)&(ksav >= 0)
*xi: reg  logTurnRate9596 i.sic logsize  ksavadjlsize [aw=we1] if (ksavadj <= 0.5)&(ksavadj >= 0)

replace we1 = (est1994+est1997)^2/unest
*xi: reg  logTurnRate9497 i.sic logsize  ksavlsize [aw=we1] if (ksav <= 0.5)&(ksav >= 0)
*xi: reg  logTurnRate9497 i.sic logsize  ksavadjlsize [aw=we1] if (ksavadj <= 0.5)&(ksavadj >= 0)

replace we1 = (est1995+est1996)^2/unest
replace we2 = we1/(1-ksav)^2
*xi: reg  logTurnRate9596 i.sic logsize  ksavlsize [aw=we2]if (ksav <= 0.5)&(ksav >= 0)
replace we2 = we1/(1-ksavadj)^2
*xi: reg  logTurnRate9596 i.sic logsize  ksavadjlsize [aw=we2]if (ksavadj <= 0.5)&(ksavadj >= 0)

replace we1 = (est1994+est1997)^2/unest
replace we2 = we1/(1-ksav)^2
xi: reg  logTurnRate9497 i.sic logsize  ksavlsize [aw=we2] if (ksav <= 0.5)&(ksav >= 0)
replace we2 = we1/(1-ksavadj)^2
xi: reg  logTurnRate9497 i.sic logsize  ksavadjlsize [aw=we2]if (ksavadj <= 0.5)&(ksavadj >= 0)



